/*****************************************************************************/
/*                         Freescale Semiconductor                           */
/*****************************************************************************/
/* File Type: Header                                                         */
/* File Name: Rend_Characters.h                                              */
/* Description: Code to write rendered characters on a NewHeaven TFT display */
/* Author: Jos Santiago Lpez Ramrez                                       */
/* Date: 11/10/10                                                            */
/*****************************************************************************/

#ifndef _Rend_Characters_H_
  #define _Rend_Characters_H_
  
/*****************************************************************************/
/*                                Includes                                   */
/*****************************************************************************/
  
   #include "FslTypes.h"
   #include "Colors.h"
 
/*****************************Available Fonts*********************************/

  //Calibri_10_Bold_Font4bpp
  //Calibri_10_Bold_Font8bpp
  //Calibri_10_Font8bpp
  //ArialBlack_10_Font4bpp
  //Tahoma_10_4BPP
  //ComicSans_10_4bppFont
  //Arial_10_4BPPFont
  //ArialRoundBold_10_4BPP
  
/************************Available Rendering Types****************************/

  //_4BPP
  //_8BPP
   
/*****************************************************************************/
/*                              Configuration                                */
/*****************************************************************************/

   #define _4BPP                                        //Defines Char Render Type
   #define ArialRoundBold_10_4BPP                       //Defines Font
   #define ltrheight             10                     //Defines Letter Height  
   #define BufferSize            200                    //Renderized char buffer lenght
   
   #ifdef _4BPP
      #define LUT_Size 16
      #define LookUpTableGen     LookUpTableGen_4bpp
      #define Char_Render_Type   Char_Render4bpp
   #endif 
   
   #ifdef _8BPP
      #define LUT_Size 256
      #define LookUpTableGen     LookUpTableGen_8bpp
      #define Char_Render_Type   Char_Render8bpp
   #endif

/*****************************************************************************/
/*                                 Globals                                   */
/*****************************************************************************/

   extern UINT8 bkgcolor [];            //Background color
   extern UINT8 fntcolor [];            //Foreground color
   extern UINT8 LookUpTable[LUT_Size][2];

/*****************************************************************************/
/*                            Character Definitions                          */
/*****************************************************************************/

   extern const UINT8 Char65 []; //Writes an A
   extern const UINT8 Char66 []; //Writes a B
   extern const UINT8 Char67 []; //Writes a C
   extern const UINT8 Char68 []; //Wirtes a D
   extern const UINT8 Char69 []; //Wirtes an E
   extern const UINT8 Char70 []; //Wirtes a F
   extern const UINT8 Char71 []; //Wirtes a G
   extern const UINT8 Char72 []; //Wirtes a H
   extern const UINT8 Char73 []; //Wirtes an I
   extern const UINT8 Char74 []; //Wirtes a J
   extern const UINT8 Char75 []; //Wirtes a K
   extern const UINT8 Char76 []; //Wirtes a L
   extern const UINT8 Char77 []; //Wirtes a M
   extern const UINT8 Char78 []; //Wirtes a N
   extern const UINT8 Char79 []; //Wirtes an O
   extern const UINT8 Char80 []; //Wirtes a P
   extern const UINT8 Char81 []; //Wirtes a Q
   extern const UINT8 Char82 []; //Wirtes a R
   extern const UINT8 Char83 []; //Wirtes a S
   extern const UINT8 Char84 []; //Wirtes a T
   extern const UINT8 Char85 []; //Wirtes an U
   extern const UINT8 Char86 []; //Wirtes a V
   extern const UINT8 Char87 []; //Wirtes a W
   extern const UINT8 Char88 []; //Wirtes a X
   extern const UINT8 Char89 []; //Wirtes a Y
   extern const UINT8 Char90 []; //Writes a Z
   extern const UINT8 Char97 []; //Wirtes an a       
   extern const UINT8 Char98 []; //Wirtes a b
   extern const UINT8 Char99 []; //Wirtes a c
   extern const UINT8 Char100 []; //Wirtes a d
   extern const UINT8 Char101 []; //Wirtes an e
   extern const UINT8 Char102 []; //Wirtes a f
   extern const UINT8 Char103 []; //Wirtes a g
   extern const UINT8 Char104 []; //Wirtes a h
   extern const UINT8 Char105 []; //Wirtes an i
   extern const UINT8 Char106 []; //Wirtes a j
   extern const UINT8 Char107 []; //Wirtes a k
   extern const UINT8 Char108 []; //Wirtes a l
   extern const UINT8 Char109 []; //Wirtes a m
   extern const UINT8 Char110 []; //Wirtes a n
   extern const UINT8 Char111 []; //Wirtes an o
   extern const UINT8 Char112 []; //Wirtes a p
   extern const UINT8 Char113 []; //Wirtes a q
   extern const UINT8 Char114 []; //Wirtes a r
   extern const UINT8 Char115 []; //Wirtes a s
   extern const UINT8 Char116 []; //Wirtes a t
   extern const UINT8 Char117 []; //Wirtes an u
   extern const UINT8 Char118 []; //Wirtes a v
   extern const UINT8 Char119 []; //Wirtes a w
   extern const UINT8 Char120 []; //Wirtes a x                           
   extern const UINT8 Char121 []; //Wirtes a y
   extern const UINT8 Char122 []; //Wirtes a z
   extern const UINT8 Char49 []; //Writes a 1
   extern const UINT8 Char50 []; //Writes a 2
   extern const UINT8 Char51 []; //Writes a 3
   extern const UINT8 Char52 []; //Writes a 4
   extern const UINT8 Char53 []; //Writes a 5
   extern const UINT8 Char54 []; //Writes a 6
   extern const UINT8 Char55 []; //Writes a 7                
   extern const UINT8 Char56 []; //Writes a 8
   extern const UINT8 Char57 []; //Writes a 9
   extern const UINT8 Char48 []; //Writes a 0
   extern const UINT8 Char33 []; //Writes a !                    
   extern const UINT8 Char63 []; //Writes a ?                   
   extern const UINT8 Char38 []; //Writes a &                                       
   extern const UINT8 Char37 []; //Writes a %
   extern const UINT8 Char44 []; //Writes a ,
   extern const UINT8 Char46 []; //Writes a .
   extern const UINT8 Char58 []; //Writes :
   extern const UINT8 Char32 []; //Writes a space
   extern const UINT8 Font_Size[]; //Defines Font Width
   
   
   

   

/*****************************************************************************/
/*                               Functions                                   */
/*****************************************************************************/

     /**
     * \brief  This function dislplays a string on the TFT Display
     * \author Jos Santiago Lpez Ramrez
     * \param  UINT8 *string: String to be displayed
     * \param  UINT8 Xspos: Starting position on X
     * \param  UINT8 Yspos: Starting position on Y
     * \return void
     * \todo   
     * \warning 
     */    
       extern void Write_Str_LCD (UINT8 *string, UINT8 Xspos, UINT8 Yspos);

     /**
     * \brief  This function prints a 4bpp renderized letter on the TFT Display
     * \author Jos Santiago Lpez Ramrez
     * \param  UINT8 *u8charstring: Character to be printed
     * \param  UINT8 xstartpos: Starting position on X
     * \param  UINT8 ystartpos: Starting position on Y
     * \return void
     * \todo   
     * \warning
     *  A 4bpp Look Up Table must have been generated before 
     */
       extern void Char_Render4bpp (const UINT8* u8charstring, UINT8 xstartpos, UINT8 ystartpos, UINT8 ltrwidth);
     
     /**
     * \brief  This function generates a 4bpp look up table according to the colors predefined in bkgcolor and fntcolor
     * \author Jos Santiago Lpez Ramrez
     * \return void
     * \todo   
     * \warning
     *  bkgcolor and fntcolor must have been defined before 
     */ 
       extern void LookUpTableGen_4bpp (void);
     
     /**
     * \brief  This function prints a 8bpp renderized letter on the TFT Display
     * \author Jos Santiago Lpez Ramrez
     * \param  UINT8 *u8charstring: Character to be printed
     * \param  UINT8 xstartpos: Starting position on X
     * \param  UINT8 ystartpos: Starting position on Y
     * \return void
     * \todo   
     * \warning
     *  A 8bpp Look Up Table must have been generated before 
     */
       extern void Char_Render8bpp (const UINT8 *u8charstring, UINT8 xstartpos, UINT8 ystartpos, UINT8 ltrwidth);
     
     /**
     * \brief  This function generates a 8bpp look up table according to the colors predefined in bkgcolor and fntcolor
     * \author Jos Santiago Lpez Ramrez
     * \return void
     * \todo   
     * \warning
     *  bkgcolor and fntcolor must have been defined before 
     */  
       extern void LookUpTableGen_8bpp (void);
       
       /**
     * \brief  This function defines a new bkgcolor and fntcolor 
     * \author Jos Santiago Lpez Ramrez
     * \param  UINT8 RF,GF,BF 24-bit RGB component for foreground
     * \param  UINT8 RB,GB,BB 24-bit RGB component for background
     * \return void
     * \todo   
     * \warning 
     */
       extern void New_fntcolor (UINT8 RF, UINT8 GF, UINT8 BF, UINT8 RB, UINT8 GB, UINT8 BB);
       
       /**
     * \brief  Look up table diag 
     * \author Jos Santiago Lpez Ramrez
     * \param  void
     * \return void
     * \todo   
     * \warning Disable in normal mode, diagnostics purpose only 
     */  
       extern void LookUpTableDiag (void);
       
       /**
     * \brief  Get_Size 
     * \author Jos Santiago Lpez Ramrez
     * \param  Char
     * \return Size
     * \todo   
     * \warning Gets Character's size 
     */  
       extern UINT8 Get_Size (UINT8 Character);

#endif